/*-*- c -*-*******************************************************************
 *
 *  Freescale Confidential Proprietary
 *
 ****************************************************************************/
#include "Common.h"
#include "tiny_ui.h"

typedef struct tuiDataBase 
{
    uint32_t      		magic;
    uint32_t      		numObjects;
    int32_t 			width, height;
    uint32_t 			objectOffsets[];
}tuiDataBase_t;

#define TUIOBJECTADDRESS(dbb,idx)      ((uint8_t *)((uint32_t)dbb+dbb->objectOffsets[idx]))                     

typedef struct tuiObject
{
	int8_t                  name[12];          
	tiny_ui_matrix_t        matrix;
	tiny_ui_blend_t		blend;
	tiny_ui_color_t         color;
	tiny_ui_path_t		path;
}tuiObject_t;

void tuiObject_read(struct tuiObject* svgto, uint8_t* buffer);
void tuiLoader_getBounds(float* bounds, uint8_t *data);
void tuiLoader_draw(uint8_t *data, tiny_ui_buffer_t *fbuffer, tiny_ui_matrix_t *matrix);